(function() {
  //    FILE:Add Panel View
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 30/12/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/bookingstructures/BookingstructuresModel', 'collections/event/EventCollection', 'models/time/TimeModel', 'collections/project/ProjectCollection', "views/project/ProjectListView", 'views/request/AddRequestView', 'views/task/AddTaskView', "views/booking/AddBookingView", 'views/menu/MenuView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, BookingstructuresModel, EventCollection, TimeModel, ProjectCollection, ProjectListView, AddRequestView, AddTaskView, AddBookingView, MenuView) {
    var AddPanelView;
    return AddPanelView = class AddPanelView extends Backbone.View {
      initialize(usr, eventsCol, obj, day, timereportsCol) {
        this.usr = usr;
        this.eventsCol = eventsCol;
        this.obj = obj;
        this.timereportsCol = timereportsCol;
        this.bookingStructures = new BookingstructuresModel();
        this.bookingStructures.get_booking_structures(this.usr);
        if (day) {
          this.dayToShow = Moment(day);
        } else {
          this.dayToShow = Moment();
        }
        this.time = new TimeModel();
        this.requestWorkingHoursStart = this.usr.get('requestWorkingHoursStart');
        this.requestWorkingHoursStop = this.usr.get('requestWorkingHoursStop');
        return this.useRequestWorkingHours = this.usr.get('useRequestWorkingHours');
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'AddPanelView'
        };
      }

      events() {
        return {
          'tap #id-btn-back': 'btnBackClicked',
          'tap #id-ul-events-type > li': 'btnAddTypeClicked',
          //POPUP CLOSE
          'tap .confirmOutsideWorkHours': 'btnOutsideWorkHoursConfirm',
          //POPUP CONFIRM
          'tap .cancelOutsideWorkHours': 'btnOutsideWorkHoursCancel'
        };
      }

      render() {
        var template;
        //@$el.empty()
        template = Handlebars.templates['AddPanelView'];
        this.$el.html(template({
          user: this.usr.toJSON(),
          dayToShow: this.dayToShow.format('Do MMM'),
          types: this.get_events_type_allowed()
        }));
        this.$el.attr('id', 'id-AddPanelView');
        this.addSidePanel();
        return this.$el;
      }

      addSidePanel() {
        //if window.media_query_min_width(768)
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      btnAddTypeClicked(event) {
        var li;
        event.preventDefault();
        event.stopPropagation();
        li = $(event.currentTarget);
        return this.addEvent_next_view(li.attr('data-type'));
      }

      addEvent_next_view(type) {
        var now, popUp, popUpHtml;
        now = this.time.get_float_from_time_string(this.usr.get('dayStartsAt'), Moment().format('HH:mm'));
        if (this.useRequestWorkingHours && (now < this.requestWorkingHoursStart || now > this.requestWorkingHoursStop)) {
          popUpHtml = "<div data-role=\"popup\" id=\"popupAlert\" data-overlay-theme=\"a\" data-theme=\"c\" data-dismissible=\"false\" class=\"ui-corner-all\">";
          popUpHtml += '<div data-role="header" data-theme="a" class="ui-corner-top">';
          popUpHtml += "<h3>This request has been submitted outside of working hours and will be processed as soon as possible. Do you wish to proceed?</h3>";
          popUpHtml += '</div>';
          popUpHtml += `<a href=\"#\" data-reqType=\"${type}\" data-role=\"button\" data-inline=\"true\" data-rel=\"back\" data-theme=\"c\" class=\"confirmOutsideWorkHours\">Confirm</a>`;
          popUpHtml += "<a href=\"#\" data-role=\"button\" data-inline=\"true\" data-rel=\"back\" data-theme=\"c\" class=\"cancelOutsideWorkHours\">Cancel</a>";
          this.$el.append(popUpHtml);
          popUp = this.$el.find('#popupAlert');
          popUp.popup();
          popUp.trigger('create');
          popUp.popup('open');
          return;
        }
        return this.do_addEvent_next_view(type);
      }

      do_addEvent_next_view(type) {
        var projectCol, texts, view;
        texts = new Object();
        texts.addHocTr = "Adhoc Time Report";
        if (window.isCompany("rt1.tv")) {
          texts.addHocTr = "Adhoc Produktionsbericht";
        }
        if (type === 'Request' || type === "Personnel Booking") {
          view = new AddRequestView(this.usr, this.obj, this.bookingStructures, this.dayToShow, this.eventsCol, type);
        } else if (type === 'Task') {
          if (!AddTaskView) {
            AddTaskView = require("views/task/AddTaskView");
          }
          view = new AddTaskView(this.usr, this.obj, this.bookingStructures, this.dayToShow, this.eventsCol);
        } else if (type === 'Booking') {
          if (!AddBookingView) {
            AddBookingView = require("views/booking/AddBookingView");
          }
          view = new AddBookingView(this.usr, this.obj, this.bookingStructures, this.dayToShow, this.eventsCol);
        } else if (type === texts.addHocTr) {
          projectCol = new ProjectCollection();
          projectCol.get_projects(this.usr);
          if (!ProjectListView) {
            ProjectListView = require("views/project/ProjectListView");
          }
          view = new ProjectListView(this.usr, projectCol, 'Adhoc', this.timereportsCol, this.obj, this.dayToShow, this.eventsCol);
        }
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      get_events_type_allowed() {
        var properties, ref, texts, types;
        types = [];
        //      unless @obj ##HIMSELF
        //        if @usr.__can_create_requests_himself() then types.push('Request')
        //        if @usr.__can_create_tasks_himself() then types.push('Task')
        //        if @usr.__can_create_bookings_himself() then types.push('Booking')
        //        if @usr.__can_create_bookings_himself() then types.push('Adhoc Time Report')

        //        if @usr.__can_create_personnel_himself() then types.push('Personnel Booking')
        //      else   ##OTHER OBJ
        texts = new Object();
        texts.addHocTr = "Adhoc Time Report";
        if (window.isCompany("rt1.tv")) {
          texts.addHocTr = "Adhoc Produktionsbericht";
        }
        properties = (ref = _.compact(_.pluck(this.eventsCol.toJSON(), 'EventObjectsProperties'))) != null ? ref[0] : void 0;
        if ((properties != null ? properties.createRequests : void 0) === 'yes') {
          types.push('Request');
        }
        if ((properties != null ? properties.createTasks : void 0) === 'yes') {
          types.push('Task');
        }
        if ((properties != null ? properties.createBookings : void 0) === 'yes') {
          types.push('Booking');
        }
        if ((properties != null ? properties.canBeAddedToTimereport : void 0) === 1) {
          types.push(texts.addHocTr);
        }
        if ((properties != null ? properties.createPersonnel : void 0) === 'yes') {
          types.push('Personnel Booking');
        }
        if ((properties != null ? properties.createMaintenance : void 0) === 'yes') {
          types.push('Maintenance');
        }
        return types;
      }

      btnBackClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        if (!this.obj) {
          $('#id-h1-navbar-title').text(this.usr.get('usersFullName'));
        } else {
          $('#id-h1-navbar-title').text(this.obj.get('objectName'));
        }
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

      btnOutsideWorkHoursConfirm(event) {
        var btn, type;
        btn = $(event.currentTarget);
        type = btn.attr('data-reqType');
        this.do_addEvent_next_view(type);
        return this.$el.find('#popupAlert').remove();
      }

      btnOutsideWorkHoursCancel(event) {
        event.preventDefault();
        event.stopPropagation();
        this.$el.find('#popupAlert').remove();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
